#include <stdio.h>

#include "../../shared/FG4iface.h"	// Obtained from compilation FG4iface.idl file.
#include "CameraPropTester.h"

extern "C" {
unsigned GetTickCount_ms(void);
unsigned long long GetTickCount_us(void);
}


////////////////////////////////////////////////////////////////////////////////////////////

class MyCallback: public ITriggerCallback
{
protected:
    ULONG m_UssageCount;
public:
    MyCallback(void) {m_UssageCount=1;m_CallbackCount1=m_CallbackCount2=m_lTrigger1Count=m_lTrigger2Count=0;}

    STDMETHODIMP QueryInterface(REFIID riid, __RPC__deref_out  void **ppvObject);
    ULONG STDMETHODCALLTYPE AddRef(void);
    ULONG STDMETHODCALLTYPE Release(void);

    STDMETHODIMP EventTrigger1(unsigned long lTrigger1Count);
    STDMETHODIMP EventTrigger2(unsigned long lTrigger2Count);

    int m_CallbackCount1, m_CallbackCount2;
    unsigned long m_lTrigger1Count, m_lTrigger2Count;
};


ULONG MyCallback::AddRef(void)
{
  return InterlockedIncrement(&m_UssageCount);
}

ULONG MyCallback::Release(void)
{
  if(m_UssageCount>1)
      return InterlockedDecrement(&m_UssageCount);

  m_UssageCount=0;
  delete this;
  return 0;
}


HRESULT MyCallback::QueryInterface(REFIID riid, __RPC__deref_out void **ppvObject)
{
  if(ppvObject == NULL) return E_POINTER;

  if(riid == __uuidof(ITriggerCallback))
  {
    AddRef();
    *ppvObject = static_cast<ITriggerCallback*>(this);
    return S_OK;
  }
  if(riid == __uuidof(IUnknown))
  {
    AddRef();
    *ppvObject = static_cast<IUnknown*>(this);
    return S_OK;
  }

  *ppvObject = NULL;
  return E_NOINTERFACE;
}


HRESULT MyCallback::EventTrigger1(unsigned long lTrigger1Count)
{
  printf("\n%llu[us] (%p) MyCallback::EventTrigger1 %u", GetTickCount_us(), this, lTrigger1Count);
  m_lTrigger1Count = lTrigger1Count;
  m_CallbackCount1++;
  return S_OK;
}


HRESULT MyCallback::EventTrigger2(unsigned long lTrigger2Count)
{
  printf("\n%llu[us] (%p) MyCallback::EventTrigger2 %u", GetTickCount_us(), this, lTrigger2Count);
  m_lTrigger2Count = lTrigger2Count;
  m_CallbackCount2++;
  return S_OK;
}



/////////////////////////////////////////////////////////////////////////////////////////////


void TestManTriggerCb(IFG4KsproxyTriggerConfig *pFG4Prop)
{
MyCallback MCB[2];
int i;

  pFG4Prop->RegisterCallback(&MCB[0]);
  pFG4Prop->RegisterCallback(&MCB[1]); 

  printf("\nPlease press ENTER to finish");
  getchar();

  printf("\nMyCallbackObject1 [%u,%u]",MCB[0].m_CallbackCount1, MCB[0].m_CallbackCount2);
  printf(" MyCallbackObject2 [%u,%u]",MCB[0].m_CallbackCount1, MCB[0].m_CallbackCount2);

  for(i=0; i<sizeof(MCB)/sizeof(MyCallback); i++)
  {
    pFG4Prop->UnRegisterCallback(&MCB[i]);
  }
}