/***************************************************************************************/
/**                            About window of HW SW switch.
 *                              (c)2019 Digiteq automotive
 ****************************************************************************************/
#include <QDialog>
#include "SynthParams.h"
#include "FG4_GUI_Version.h"


SynthParams::SynthParams(QWidget *parent):
    QDialog(parent),
    m_ui(new Ui::SynthParams)   
{

    m_ui->setupUi(this);
    //m_ui->label_versionBuild->setText(QString("Version %1, build %2.").arg(VERSIONSTR).arg(RELEASEDATE));
    //m_ui->label_QtVersion->setText(QString("Running on Qt version %1, built against version %2.").arg(qVersion()).arg(QT_VERSION_STR));
    //m_ui->label_iniFile->setText(QString("Setting loaded from file %1.").arg(settings.FileName()));
    //m_ui->label_logFile->setText(QString("Logging into directory %1.").arg(settings.m_LogDir));
}


SynthParams::~SynthParams()
{
  if(m_ui) {delete m_ui; m_ui=NULL;}
}


void SynthParams::slotClicked_close()
{
    done(QDialog::Accepted);
}


void SynthParams::SetWidth(unsigned SynthWidth)
{
  if(m_ui==NULL) return;
  m_ui->Edit_Width->setText(QString::number(SynthWidth));
}


void SynthParams::SetHeight(unsigned SynthHeight)
{
  if(m_ui==NULL) return;
  m_ui->Edit_Height->setText(QString::number(SynthHeight));
}


void SynthParams::SetFPS(unsigned FPS)
{
  if(m_ui==NULL) return;
  m_ui->Edit_Fps->setText(QString::number(FPS));
}


void SynthParams::SetHackLastPx(bool HackLastPx)
{
  if(m_ui==NULL) return;
  m_ui->Chk_HackLastPixel->setChecked(HackLastPx);
}


unsigned SynthParams::GetWidth(void)
{
  if(m_ui==NULL) return 0;
  QString Str = m_ui->Edit_Width->text();
  return Str.toInt();
}


unsigned SynthParams::GetHeight(void)
{
  if(m_ui==NULL) return 0;
  QString Str = m_ui->Edit_Height->text();
  return Str.toInt();
}


unsigned SynthParams::GetFPS(void)
{
  if(m_ui==NULL) return 0;
  QString Str = m_ui->Edit_Fps->text();
  return Str.toInt();
}


bool SynthParams::GetHackLastPx(void)
{
  if(m_ui==NULL) return false;
  return m_ui->Chk_HackLastPixel->isChecked();
}
