
QT       += core gui network
# xmlpatterns

greaterThan(QT_MAJOR_VERSION, 4): QT += widgets

TARGET = OutputGen

TEMPLATE = app

CONFIG -= embed_manifest_dll embed_manifest_exe flat

DEFINES -= UNICODE
DEFINES += _REENTRANT

SOURCES +=  mainOutGen.cpp \
	    Frm_OutGen.cpp \
	    ../daqshare/xdma.c \
            ../../lib/logger/logfile.cpp \
            ../../lib/logger/logmsg.cpp \
            ../../lib/logger/logQt.cpp \
            ../../lib/images/error.cc \
	    ../../lib/images/filehnd.cc \
	    ../../lib/images/imgsupp.cc \
            ../../lib/images/ras_img.cc \
	    ../../lib/images/raster.cc \
	    ../../lib/images/vecimage.cc \
	    ../../lib/images/rasterut.cc \
            ../../lib/images/rasterc.c \
            ../../lib/atoms/mtx_impl.cc \
            ../../lib/atoms/std_str.cc \
	    ../../lib/atoms/strings.cc \
            ../../lib/atoms/struct.c \
            ../../lib/misc/GetTickCount_ms.c


HEADERS  += Frm_OutGen.h \
            ../../lib/logger/logmsg.h \
            ../../lib/logger/logfile.h \
	    ../../lib/logger/logQt.h \
            ../../lib/logger/csext.h


FORMS    += OutputGen.ui

RESOURCES += FG4GUI.qrc

INCLUDEPATH += ../../lib/logger \
               ../../lib/atoms \
               ../../lib/images \
	       ../../lib/daqshare

DEPENDPATH  += ../../lib/logger

INCLUDEPATH += ../../driver/floppy/examples
DEPENDPATH  += ../../driver/floppy/examples


unix {
    #CONFIG+=configPA
    configPA {
        QMAKE_CXXFLAGS += -Werror
        #http://stackoverflow.com/questions/5088460/flags-to-enable-thorough-and-verbose-g-warnings/9862800#9862800
        #QMAKE_CXXFLAGS += -pedantic -Wall -Wextra -Wcast-align -Wcast-qual -Wctor-dtor-privacy
        #QMAKE_CXXFLAGS += -Wdisabled-optimization -Wformat=2 -Winit-self -Wlogical-op -Wmissing-declarations
        #QMAKE_CXXFLAGS += -Wmissing-include-dirs -Wnoexcept -Wold-style-cast -Woverloaded-virtual -Wredundant-decls -Wshadow
        #QMAKE_CXXFLAGS += -Wsign-conversion -Wsign-promo -Wstrict-null-sentinel -Wstrict-overflow=5 -Wswitch-default -Wundef -Werror
        #QMAKE_CXXFLAGS += -Wno-unused
    }

    MY_RELEASE_DESTDIR  = release
    MY_DEBUG_DESTDIR    = debug
}


#win32-msvc2008 {
#win32-msvc2010 {
win32 {
    QMAKE_CXXFLAGS += -D_WIN32_WINNT=0x0501
    SOURCES += ../../lib/stackwalker/StackWalker.cpp
    HEADERS += ../../lib/stackwalker/StackWalker.h
    INCLUDEPATH += ../../lib/stackwalker
    MSVCPROJ_LIBS += Version.lib
    RC_FILE = OutGen.rc

    MSVCPROJ_LIBS += hudaqlib.lib 
    LIBS += -L"../../LIBRARY/bin/win32"
    INCLUDEPATH += ../../LIBRARY/src

    MY_RELEASE_DESTDIR  = release
    MY_DEBUG_DESTDIR    = debug

    MSVCPROJ_LIBS += Ws2_32.lib
    MSVCPROJ_LIBS += Dnsapi.lib
    CONFIG(release, debug|release) {
        QMAKE_LFLAGS += /MAP
    }

    CONFIG(debug, debug|release) {
    }

    QMAKE_CXXFLAGS += -wd4996
}


win32-msvc2012 {
    SOURCES += ../../lib/stackwalker/StackWalker.cpp
    HEADERS += ../../lib/stackwalker/StackWalker.h
    TARGET = TesseractGUI64
    QMAKE_TARGET.arch = x86_64
    DEFINES += NOMINMAX

    QMAKE_LIBS += Version.lib
    RC_FILE     = ControlDesk.rc

    MSVCPROJ_LIBS += Ws2_32.lib
    MSVCPROJ_LIBS += Dnsapi.lib

    MY_RELEASE_DESTDIR  = release64
    MY_DEBUG_DESTDIR    = debug64

    CONFIG(release, debug|release) {
        QMAKE_LFLAGS += /MAPINFO:EXPORTS
    }

    CONFIG(debug, debug|release) {
    }

    # this might still need some attention
    message(QMAKE_CFLAGS=$$QMAKE_CFLAGS)
    QMAKE_CFLAGS   -= -Zc:wchar_t
    message(QMAKE_CFLAGS=$$QMAKE_CFLAGS)
    #QMAKE_CFLAGS   += "/Zc:wchar_t-"
    CFLAGS_EXTRA      = /Zc:wchar_t-
    message(QMAKE_CFLAGS=$$QMAKE_CFLAGS)
}


release:DESTDIR     = $$MY_RELEASE_DESTDIR
release:OBJECTS_DIR = $$MY_RELEASE_DESTDIR/.obj
release:MOC_DIR     = $$MY_RELEASE_DESTDIR/.moc
release:RCC_DIR     = $$MY_RELEASE_DESTDIR/.rcc
release:UI_DIR      = $$MY_RELEASE_DESTDIR/.ui

debug:DESTDIR       = $$MY_DEBUG_DESTDIR
debug:OBJECTS_DIR   = $$MY_DEBUG_DESTDIR/.obj
debug:MOC_DIR       = $$MY_DEBUG_DESTDIR/.moc
debug:RCC_DIR       = $$MY_DEBUG_DESTDIR/.rcc
debug:UI_DIR        = $$MY_DEBUG_DESTDIR/.ui

