//------------------------------------------------------------------------------
// File: fFrameBuffer.h
//
// Desc: DirectShow sample code - main header file for the bouncing ball
//       source filter.  For more information refer to Ball.cpp
//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// Forward Declarations
//------------------------------------------------------------------------------
// The class managing the output pin
class CFrameBuffStream;

//#include "BallIface_h.h"

extern "C" {
unsigned GetTickCount_ms(void);
}


//------------------------------------------------------------------------------
// Class CFrameBuffer
//
// This is the main class for the renderer feeder filter. It inherits from
// CSource, the DirectShow base class for source filters.
//------------------------------------------------------------------------------
class CFrameBuffer: public IAMStreamConfig, public CSource // public ISpecifyPropertyPages, public IBallProxySampleConfig
{
public:

    DECLARE_IUNKNOWN;

	// The only allowed way to create CFrameBuffer!
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

	// Reveals ISpecifyPropertyPages
    //STDMETHODIMP NonDelegatingQueryInterface(REFIID riid, void ** ppv);

	// ISpecifyPropertyPages interface
    //STDMETHODIMP GetPages(CAUUID *pPages);

	// IRendererFeederConfig overriden methods:
    STDMETHODIMP GetWidth(long* plWidth);
    STDMETHODIMP SetWidth(long lWidth);
    STDMETHODIMP GetHeight(long* plHeight);
    STDMETHODIMP SetHeight(long lHeight);
    STDMETHODIMP GetBallSize(long* plBallSize);
    STDMETHODIMP SetBallSize(long lBallSize);
    STDMETHODIMP GetRepeatTime_ms(long* plRepeatTime_ms);
    STDMETHODIMP SetRepeatTime_ms(long lRepeatTime_ms);
    STDMETHODIMP FeedExternalBuffer(unsigned const char *BufPtr, unsigned BufSize);
    STDMETHODIMP GetSafetyTimer(long* plWidth);
    STDMETHODIMP SetSafetyTimer(long lWidth);

	// IAMStreamConfig
    STDMETHODIMP SetFormat(AM_MEDIA_TYPE *pmt);
    STDMETHODIMP GetFormat(AM_MEDIA_TYPE **ppmt);
    STDMETHODIMP GetNumberOfCapabilities(int *piCount, int *piSize);
    STDMETHODIMP GetStreamCaps(int iIndex, AM_MEDIA_TYPE **ppmt, BYTE *pSCC);

	// It is only allowed to to create these objects with CreateInstance
    CFrameBuffer(LPUNKNOWN lpunk, HRESULT *phr);

	// IMediaFilter - https://learn.microsoft.com/en-us/windows/win32/api/strmif/nn-strmif-imediafilter
    STDMETHODIMP Run(REFERENCE_TIME tStart);
    STDMETHODIMP Pause(void);
    STDMETHODIMP Stop(void);

private:
  
    CFrameBuffStream *m_CFrameBuffStream;
}; // CFrameBuffer


//------------------------------------------------------------------------------
// Class CFrameBuffStream
//
// This class implements the stream which is used to output the bouncing ball
// data from the source filter. It inherits from DirectShows's base
// CSourceStream class.
//------------------------------------------------------------------------------
class CFrameBuffStream: public CSourceStream, public IAMStreamConfig, public IKsPropertySet
{
public:

    DECLARE_IUNKNOWN;

    CFrameBuffStream(HRESULT *phr, CFrameBuffer *pParent, LPCWSTR pPinName);
    ~CFrameBuffStream();

    HRESULT FeedExternalBuffer(unsigned const char *BufPtr, unsigned BufSize);

    // plots a ball into the supplied video frame
    HRESULT FillBuffer(IMediaSample *pms);

    // Ask for buffers of the size appropriate to the agreed media type
    HRESULT DecideBufferSize(IMemAllocator *pIMemAlloc, ALLOCATOR_PROPERTIES *pProperties);

    // Set the agreed media type, and set up the necessary ball parameters
    HRESULT SetMediaType(const CMediaType *pMediaType);

    // Because we calculate the ball there is no reason why we
    // can't calculate it in any one of a set of formats...
    HRESULT CheckMediaType(const CMediaType *pMediaType);
    HRESULT GetMediaType(int iPosition, CMediaType *pmt);

    const CMediaType *GetCurrentMediaType(void) const;

    // Resets the stream time to zero

    HRESULT OnThreadCreate(void);

    // Quality control notifications sent to us
    STDMETHODIMP Notify(IBaseFilter * pSender, Quality q);

    HRESULT Run();

    STDMETHODIMP NonDelegatingQueryInterface(REFIID riid, void ** ppv);

	// IAMStreamConfig
    STDMETHODIMP GetFormat(AM_MEDIA_TYPE **ppmt);
    STDMETHODIMP SetFormat(AM_MEDIA_TYPE *pmt);
    STDMETHODIMP GetNumberOfCapabilities(int *piCount, int *piSize);
    STDMETHODIMP GetStreamCaps(int iIndex, AM_MEDIA_TYPE **ppmt, BYTE *pSCC);

	// IKsPropertySet
    STDMETHODIMP Get(REFGUID guidPropSet, DWORD dwPropID, LPVOID  pInstanceData, DWORD cbInstanceData, LPVOID pPropData, DWORD cbPropData, DWORD *pcbReturned);
    STDMETHODIMP QuerySupported(REFGUID guidPropSet, DWORD dwPropID, DWORD *pTypeSupport);
    STDMETHODIMP Set(REFGUID guidPropSet, DWORD dwPropID, LPVOID pInstanceData, DWORD cbInstanceData, LPVOID pPropData, DWORD cbPropData);

    int m_iImageHeight;			// The current image height
    int m_iImageWidth;			// And current image width
    unsigned m_iRepeatTime;		// Time in msec between frames
    int m_iBallSize;
    int m_SafetyTimer;

private:
    const unsigned m_iDefaultRepeatTime;	// Initial m_iRepeatTime

    BYTE m_BallPixel[4];		// Represents one coloured ball
    int m_iPixelSize;			// The pixel size in bytes
    PALETTEENTRY m_Palette[256];	// The optimal palette for the image

    CCritSec m_cSharedState;		// Lock on m_rtSampleTime and m_Ball
    CRefTime m_rtSampleTime;		// The time stamp for each sample
    CBall *m_Ball;			// The current ball object
    unsigned LastFrame_ms;
    unsigned LastExtFrame_ms;

	// set up the palette appropriately
    enum Colour {Red, Blue, Green, Yellow};
    HRESULT SetPaletteEntries(Colour colour);
    virtual HRESULT DoBufferProcessingLoop(void);
}; // CFrameBuffStream
